#include <Adafruit_NeoPixel.h>
#define PIN_WS2812B  2   // The Arduino Nano pin that connects to WS2812B
#define NUM_PIXELS   10  // The number of LEDs (pixels) on WS2812B   
Adafruit_NeoPixel WS2812B(NUM_PIXELS, PIN_WS2812B, NEO_GRB + NEO_KHZ800); 
int colors[3] = {0,255,0}; //red to purple/wihte 
int velocity = 100;
int length = 3;
int end = 20;

void setup() {
  WS2812B.begin(); // INITIALIZE WS2812B strip object (REQUIRED)
  WS2812B.setBrightness(1);
  Serial.begin(9600);
}

void loop() {
  for (int t = -length; t <= end; t++) {
    snake(length, t);  
    snake(length, t - 4);
     
    delay(velocity);
    WS2812B.show();
  }
  WS2812B.clear();  
}  

void pixel_show(int n){
  if (n < NUM_PIXELS && n >= 0){
    WS2812B.setPixelColor(n, WS2812B.Color(colors[0],colors[1],colors[2]));
  }
}

void snake(int n, int t){
  for (int i = 0; i <= n-1; i++) {
    pixel_show(t+i);
  }
  if (t<=NUM_PIXELS && t>0){
     WS2812B.setPixelColor(t-1, WS2812B.Color(0,0,0));
  }
}

