#include <Adafruit_NeoPixel.h>
#define PIN_WS2812B  2   // The Arduino Nano pin that connects to WS2812B
#define NUM_PIXELS   64  // The number of LEDs (pixels) on WS2812B
#define SOUND_PIN    8   
int cnt = 800;
Adafruit_NeoPixel WS2812B(NUM_PIXELS, PIN_WS2812B, NEO_GRB + NEO_KHZ800); 
int colors[8][3] = {{0,255,0},{0,255,0},{255,255,0},{255,255,0},{255,150,0},{255,150,0},{255,0,0},{255,0,0}}; //red to purple/wihte 
//int rainbow[8][3] = {{255,0,0},{255,153,0},{255,255,0},{0,255,0},{0,0,255},{255,0,255},{150,  0,  150},{255,255,255}}; //red to purple/wihte

void setup() {
  WS2812B.begin(); // INITIALIZE WS2812B strip object (REQUIRED)
  WS2812B.setBrightness(1);
  Serial.begin(9600);
}

void loop() {
  if (digitalRead(SOUND_PIN) == LOW){
    cnt = 800;
  }

  for (int i = 0; i <= 7; i++) {
    if (cnt > i*100){
      color_bar(i);
    }
  }

  if (cnt > 0 ) {
    cnt = cnt - 4;
  }

  WS2812B.show();
  WS2812B.clear();  
}
  
void color_bar(int n) {
  for (int j = 0; j <= 7; j++) {
    for (int i = 0; i <= n; i++) {    
      WS2812B.setPixelColor(i + j*8, WS2812B.Color(colors[i][0],colors[i][1],colors[i][2]));
    }  
  }
}