#include <Adafruit_NeoPixel.h>
int A_char[8][8] = {{0,0,1,1,1,1,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0}};
int D_char[8][8] = {{0,1,1,1,1,1,0,0},
		  {0,1,1,1,1,1,0,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,0,0}};		  
int E_char[8][8] = {{0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,0,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,0,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0}};
		  
int F_char[8][8] = {{0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,0,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,0,0,0},
		  {0,1,1,0,0,0,0,0},
		  {0,1,1,0,0,0,0,0}};		  
		  
int G_char[8][8] = {{0,0,1,1,1,1,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,0,0,0},
		  {0,1,1,0,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,0,1,1,1,1,0,0}};		  
		  		  
int H_char[8][8] = {{0,0,0,0,0,1,1,0},
		  {0,0,0,0,0,1,1,0},
		  {0,0,0,0,0,1,1,0},
		  {0,0,0,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,0,1,1,1,1,0,0}};

int I_char[8][8] = {{0,0,0,1,1,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0}};			  
int R_char[8][8] = {{0,1,1,1,1,1,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,0,0},
		  {0,1,1,1,1,0,0,0},
		  {0,1,1,0,1,1,0,0},
		  {0,1,1,0,0,1,1,0}};	  
int M_char[8][8] = {{1,1,1,0,0,1,1,1},
		  {1,1,1,1,1,1,1,1},
		  {1,1,1,1,1,1,1,1},
		  {1,1,0,1,1,0,1,1},
		  {1,1,0,0,0,0,1,1},
		  {1,1,0,0,0,0,1,1},
		  {1,1,0,0,0,0,1,1},
		  {1,1,0,0,0,0,1,1}};
		  
int N_char[8][8] = {{0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0}};
	
int O_char[8][8] = {{0,0,1,1,1,1,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,0,1,1,1,1,0,0}};
		  
int P_char[8][8] = {{0,1,1,1,1,1,0,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,0,0},
		  {0,1,1,0,0,0,0,0},
		  {0,1,1,0,0,0,0,0}};		  
		  
int T_char[8][8] = {{0,1,1,1,1,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0}};
int U_char[8][8] = {{0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,1,1,1,1,1,1,0},
		  {0,0,1,1,1,1,0,0}};		  		  	  
int Y_char[8][8] = {{0,1,1,0,0,1,1,0},
		  {0,1,1,0,0,1,1,0},
		  {0,0,1,1,1,1,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0},
		  {0,0,0,1,1,0,0,0}};
		    				
#define brightness   1
#define PIN_WS2812B  2   // The Arduino Nano pin that connects to WS2812B
#define NUM_PIXELS   64  // Number of Pixels
Adafruit_NeoPixel WS2812B(NUM_PIXELS, PIN_WS2812B, NEO_GRB + NEO_KHZ800); 
int start = -6; 
int duration = 50;
int t = start;

void setup() {
  WS2812B.begin(); // INITIALIZE WS2812B strip object (REQUIRED)
  WS2812B.setBrightness(brightness);
  Serial.begin(9600);
}

void loop() {
  // put your main code here, to run repeatedly:
	WS2812B.clear();		
	slide_char(A_char, t, 7*0); 
	slide_char(R_char, t, 7*1);
	slide_char(D_char, t, 7*2);
  slide_char(U_char, t, 7*3); 
	slide_char(I_char, t, 7*4);
	slide_char(N_char, t, 7*5);
  slide_char(O_char, t, 7*6);


	delay(100);

	t = t + 1;							
	if (t > duration){
    t = start;
  }
	WS2812B.show(); 
}

int matrix_to_array_converter(int matrix[8][8]){
	int i = 0;
	int array[NUM_PIXELS]	= {0,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0};	
				
  for (int x; x <= 7; x++){ 
		for (int y; y <= 7; y++){
			array[i] = matrix[x][y]; 
			i = i + 1;
    }
  }  
	return array;
}

int matrix_to_array_nr(int x, int y){
		int array[8][8]	 = {{ 0, 1, 2, 3, 4, 5, 6, 7},
					{ 8, 9,10,11,12,13,14,15},
					{16,17,18,19,20,21,22,23},
					{24,25,26,27,28,29,30,31},
					{32,33,34,35,36,37,38,39},
					{40,41,42,43,44,45,46,47},
					{48,49,50,51,52,53,54,55},
					{56,57,58,59,60,61,62,63}};					
		return array[x][y];	 
}

void print_char(int array[8][8] ){
	for (int x = 0 ; x <= 7; x++){ 
		for (int y = 0 ; y <= 7; y++){
			if (array[x][y] == 1){
			  WS2812B.setPixelColor(matrix_to_array_nr(x,y),0,255,250);
			  WS2812B.show();
			  
      }
    }
  }	 
}
	
void slide_char(int ch[8][8], int t, int delay){	
  for (int x = 0 ; x <= 7; x++){ 
    for (int y = 0 ; y <= 7; y++){
      if (ch[x][y] == 1 && y-t+delay >= 0 && y-t+delay < 8){
        WS2812B.setPixelColor(matrix_to_array_nr(x,y-t+delay),85,26,139);		
        
      } 
    }
  }
  WS2812B.show();
}
